string GetDescription()
{
	return "ABA classical structure with either 3 or 4 metrum";
}

void GenerateStructure(Song@ song)
{
	song.SetUniqueParts(2);
	
	int metrum = RndInt(3,4);
	
	for (int i = 0; i < song.GetUniqueParts(); i++)
	{
		UniquePart@ up = song.GetUniquePart(i); 
		up.SetMetrum(metrum);
	}
	
	song.SetParts(3);	

	int[] trans(3);

	trans[0] = RndInt(0, 11);
	trans[1] = (trans[0] + 5) % 12;
	trans[2] = (trans[1] + 5) % 12;

	if (RndInt(0,2) == 0) trans[0] = trans[1];
	if (RndInt(0,2) == 0) trans[2] = trans[1];

	for (int i = 0; i < song.GetParts(); i++)
	{
		Part@ p = song.GetPart(i);
		p.SetTempoMod(1.0);
		p.SetTranspose(trans[i]);
		p.SetScale(GetRandomScale());
		p.SetUniquePart(i%song.GetUniqueParts());
		p.SetArrHint(RndInt(1,3));
	}
}